#include<uart.h>
#include<p30fxxxx.h>

/*UART2 is defined in following devices */
#if defined(__dsPIC30F3011__) || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || \
    defined(__dsPIC30F3013__) || defined(__dsPIC30F3014__) || defined(__dsPIC30F5011__)	|| \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__)

/*************************************************************************
* Function Name     : ReadUART2
* Description       : This function returns the contents of UxRXREG buffer
* Parameters        : None
* Return Value      : unsigned int value from UxRXREG receive buffer 
*************************************************************************/

unsigned int ReadUART2(void)
{
    if(U2MODEbits.PDSEL == 3)
        return (U2RXREG);
    else
        return (U2RXREG & 0xFF);
}

#endif
